/*------------------------------------------------------------------------------*
 * File Name:	UserTreeGUI.c 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
 
#include <Origin.h>

#pragma labtalk(0) // to disable OC functions for LT calling.

////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.
#include <Control.h>
#include <ocu.h> 
#include <GetNBox.h>
#include "UserTreeGUI.h"

////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.

//user tree gui
///Jasmine 11/06/09 QA80-14502 REWRITE_CODE_TO_SHARE_COL_PROP_USER_TREE_CODE
UserTreeMenu::UserTreeMenu(bool bDelete, bool bTree, bool bNode)
{
	m_nChoice = -1;		
	Add(_L("Rename"), OnMenuItem, bDelete? MF_ENABLED : MF_DISABLED | MF_GRAYED);
	Add(_L("Delete"), OnMenuItem, bDelete? MF_ENABLED : MF_DISABLED | MF_GRAYED);
	Add(_L("Add Tree"), OnMenuItem, bTree? MF_ENABLED : MF_DISABLED | MF_GRAYED);	
	Add(_L("Add Node"), OnMenuItem, bNode? MF_ENABLED : MF_DISABLED | MF_GRAYED);	
}	
bool UserTreeMenu::GetCommand(int& nChoice)
{		
	if(m_nChoice >= USERTREEMENU_EDIT && m_nChoice <= USERTREEMENU_LAST_ITEM)
	{
		nChoice = m_nChoice;
		return true;
	}
	return false;
}
///End REWRITE_CODE_TO_SHARE_COL_PROP_USER_TREE_CODE

/// Hong 11/13/09 QA80-14502 WBK_ORGANIZER_USER_TREE_EDIT_GUI_THE_SAME_AS_COL_PROPERTY
///Jasmine 01/31/07 QA70-9287 EDIT_STORAGE
int storage_tree_check_node_name(const TreeNode& trParent, string strName)
{
	if(strName.IsEmpty())
		return -1;
	
	///Jasmine 03/21/07 MODIFICATION_EDIT_USER_TREE
	vector<string> vs;
	int	nSize =	strName.GetTokens(vs, '.');
	for(int ii = 0; ii < nSize; ii++) 
	{
		string strTag = vs[ii];
		strTag.MakeValidCName();
		if(strTag.IsEmpty() || strTag.CompareNoCase(vs[ii]))
			return -1;
	}
	///End MODIFICATION_EDIT_USER_TREE
	
	bool bOK = true;
	foreach(TreeNode cNode in trParent.Children)
	{
		if(!strName.CompareNoCase(cNode.tagName))
		{
			bOK = false;
			break;
		}
	}
	return bOK? CER_NO_ERROR : CER_NAME_ALREADY_EXIST;
}
///End EDIT_STORAGE


bool usertree_input_node_name(TreeNode &trParent, string& strName, string& strLabel, int& nNodeType, HWND hWndParent/* = NULL*/, DWORD dwCntrl/* = 0*/, LPCSTR lpcszTitle/* = NULL*/, LPCSTR lpcszName/* = NULL*/, LPCSTR lpcszNote/* = NULL*/)
{
	string strHints;
	ocu_load_msg_str(CER_TAGNAME_ONLY_ALLOW_LETTER_AND_NUMBER, &strHints);
	
	GETN_TREE(trAdd)
	GETN_STR(notes, "", lpcszNote ? lpcszNote : strHints) GETN_READ_ONLY_COLOR
	GETN_STR(name, _L("Name"), lpcszName ? lpcszName : "")		GETN_EDIT_DISPLAY_WIDTH_RANGE( "30-30" )
	///Jasmine 10/29/09 QA80-14502 DISPLAY_LABEL_AND_TAGNAME_FOR_USER
	GETN_STR(label, _L("Label"), "")	GETN_EDIT_DISPLAY_WIDTH_RANGE( "30-30" )
	///End DISPLAY_LABEL_AND_TAGNAME_FOR_USER
	GETN_LIST(type, _L("Type"), 1, _L("Numeric|Text|Branch"))
	
	// Hong, can't compile vsFlexGrid if use enum, bug??
	bool bShowLabelNode = (USERTREE_HIDE_LABEL_NODE & dwCntrl) ? FALSE : TRUE;
	bool bShowTypeNode = (USERTREE_HIDE_TYPE_NODE & dwCntrl) ? FALSE : TRUE;
	trAdd.label.Show = bShowLabelNode;
	trAdd.type.Show = bShowTypeNode;
	
	for ( ; ; )
	{
		string 		strName = trAdd.name.strVal;
		
		int nErr = storage_tree_check_node_name(trParent, strName);
		if(nErr == CER_NO_ERROR)
			break;
			
		if(nErr == CER_NAME_ALREADY_EXIST)
			warning_msg_box(CER_NAME_ALREADY_EXIST, true);
		
		if ( !GetNBox(trAdd, lpcszTitle ? lpcszTitle : _L("Add Tree Node"), NULL, NULL, NULL, hWndParent) )
			return "";
	}
	strName = trAdd.name.strVal;
	
	strLabel = "";
	if ( bShowLabelNode )
	{
		strLabel = trAdd.label.strVal;
		strLabel.TrimLeft();
		strLabel.TrimRight();
	}
		
	nNodeType = bShowTypeNode? trAdd.type.nVal : USERTREE_BRANCH_NODE;
	
	ASSERT( !strName.IsEmpty() );
	return true;
}
/// end WBK_ORGANIZER_USER_TREE_EDIT_GUI_THE_SAME_AS_COL_PROPERTY

///Jasmine 11/06/09 QA80-14502 REWRITE_CODE_TO_SHARE_COL_PROP_USER_TREE_CODE
bool usertree_make_node(TreeNode& trNew, TreeNode& trParent, const string& strName, const string& strLabel, int nNodeType)
{
	string strTag = strName;
	strTag.MakeValidCName();
	if(strTag.IsEmpty() || strTag.CompareNoCase(strName) != 0 || !trParent)
		return false;
		
	switch(nNodeType)
	{
	case USERTREE_NUMERIC_NODE:
		trNew = trParent.AddNumericNode(0, strName);
		break;
	case USERTREE_TEXT_NODE:
		trNew = trParent.AddTextNode("", strName);
		break;
	default:
		trNew = trParent.AddNode(strName, TRGP_BRANCH);			
		trNew.SetAttribute(STR_ATTRIB_BRANCH, GETNBRANCH_OPEN);
		break;
	}
	///Jasmine 10/29/09 QA80-14502 DISPLAY_LABEL_AND_TAGNAME_FOR_USER
	/// Hong 11/13/09 QA80-14502 WBK_ORGANIZER_USER_TREE_EDIT_GUI_THE_SAME_AS_COL_PROPERTY
	//string strLabel = trAdd.label.strVal;
	//strLabel.TrimLeft(); strLabel.TrimRight();
	/// end WBK_ORGANIZER_USER_TREE_EDIT_GUI_THE_SAME_AS_COL_PROPERTY
	if(!strLabel.IsEmpty() && trNew)
		trNew.SetAttribute(STR_LABEL_ATTRIB, strLabel);
	///End DISPLAY_LABEL_AND_TAGNAME_FOR_USER
	
	return true;
}

///End REWRITE_CODE_TO_SHARE_COL_PROP_USER_TREE_CODE

bool usertree_edit_node_name(TreeNode &trParent, string& strName, string& strLabel, HWND hWndParent/* = NULL*/, DWORD dwCntrl/* = 0*/, LPCSTR lpcszTitle/* = NULL*/, LPCSTR lpcszName/* = NULL*/, LPCSTR lpcszLabel/* = NULL*/, LPCSTR lpcszNote/* = NULL*/)
{
	string strHints;
	ocu_load_msg_str(CER_TAGNAME_ONLY_ALLOW_LETTER_AND_NUMBER, &strHints);
	
	GETN_TREE(trAdd)
	GETN_STR(notes, "", lpcszNote ? lpcszNote : strHints) GETN_READ_ONLY_COLOR
	GETN_STR(name, _L("Name"), lpcszName ? lpcszName : "")		GETN_EDIT_DISPLAY_WIDTH_RANGE( "30-30" )
	GETN_STR(label, _L("Label"), lpcszLabel? lpcszLabel : "")	GETN_EDIT_DISPLAY_WIDTH_RANGE( "30-30" )
	
	bool bShowLabelNode = (USERTREE_HIDE_LABEL_NODE & dwCntrl) ? FALSE : TRUE;
	trAdd.label.Show = bShowLabelNode;
	
	for ( ; ; )
	{
		if ( !GetNBox(trAdd, lpcszTitle ? lpcszTitle : _L("Rename Tree Node"), NULL, NULL, NULL, hWndParent) )
			return "";
		
		strName = trAdd.name.strVal;
		if(lpcszName && strName.Compare(lpcszName) == 0)
			break;
		
		int nErr = storage_tree_check_node_name(trParent, strName);
		if(nErr == CER_NO_ERROR)
			break;
			
		if(nErr == CER_NAME_ALREADY_EXIST)
			warning_msg_box(CER_NAME_ALREADY_EXIST, true);
	}
	
	strLabel = "";
	if ( bShowLabelNode )
	{
		strLabel = trAdd.label.strVal;
		strLabel.TrimLeft();
		strLabel.TrimRight();
	}
	
	return true;
}

bool usertree_replace_node(TreeNode& trStorage, LPCSTR lpcszNode, LPCSTR lpcszName/* = NULL*/, LPCSTR lpcszLabel/* = NULL*/)
{
	TreeNode trNode = tree_get_node_by_tagname(trStorage, lpcszNode, true);
	if(!trNode)
		return FALSE;
		
	bool bChange = false;
	if(lpcszName && lstrcmp(lpcszNode, lpcszName) != 0)
	{
		TreeNode trParent = trNode.Parent();
		TreeNode trNew = trParent.InsertNode(trNode, lpcszName);
		trNew.Replace(trNode, TRUE, TRUE);
			
		trNode.Remove();
		trNode = trNew;
		bChange = true;
	}
		
	if(lpcszLabel)
	{
		string strLabel;
		trNode.GetAttribute(STR_LABEL_ATTRIB, strLabel);
		if(lstrcmp(strLabel, lpcszLabel) != 0)
		{
			bChange = true;
			
			if(lstrlen(lpcszLabel) > 0)
				trNode.SetAttribute(STR_LABEL_ATTRIB, lpcszLabel); 
			else
				trNode.RemoveAttribute(STR_LABEL_ATTRIB);
		}
	}
	
	return bChange;
}